### R code from vignette source 'RNASeq.Rnw'

###################################################
### code chunk number 1: setup
###################################################
options(digits=2)
library(useR2011)
library(edgeR)
library(goseq)


###################################################
### code chunk number 2: counts
###################################################
data(counts)
dim(counts)
grp <- factor(sub("[1-4].*", "", colnames(counts)),
              levels=c("untreated", "treated"))


###################################################
### code chunk number 3: DGEList
###################################################
library(edgeR)
dge <- DGEList(counts, group=grp)
dge <- calcNormFactors(dge)


###################################################
### code chunk number 4: DEGList-filter
###################################################
m <- 1e6 * t(t(dge$counts) / dge$samples$lib.size)
ridx <- rowSums(m > 1) >= 2
table(ridx)   # number filtered / retained
dge <- dge[ridx,]


###################################################
### code chunk number 5: mds
###################################################
plotMDS.dge(dge)


###################################################
### code chunk number 6: design
###################################################
(design <- model.matrix( ~ grp ))


###################################################
### code chunk number 7: common.dispersion
###################################################
dge <- estimateCommonDisp(dge, design)
sqrt(dge$common.dispersion)


###################################################
### code chunk number 8: glmFit
###################################################
fit <- glmFit(dge, design, dispersion=dge$common.dispersion)


###################################################
### code chunk number 9: lrt
###################################################
lrTest <- glmLRT(dge, fit, coef=2)


###################################################
### code chunk number 10: topTags
###################################################
(tt <- topTags(lrTest))


###################################################
### code chunk number 11: sanity
###################################################
sapply(rownames(tt$table)[1:4], 
       function(x) tapply(counts[x,], grp, mean))


