### R code from vignette source 'Annotation.Rnw'

###################################################
### code chunk number 1: setup
###################################################
options(digits=2)
library(useR2011)
library(org.Dm.eg.db)


###################################################
### code chunk number 2: org.Dm.eg.db
###################################################
library(org.Dm.eg.db)
ls('package:org.Dm.eg.db')
org.Dm.egUNIPROT
class(org.Dm.egUNIPROT)
sample(org.Dm.egUNIPROT, 5)
head(toTable(org.Dm.egUNIPROT))


###################################################
### code chunk number 3: revmap
###################################################
revmap(org.Dm.egUNIGENE)
sample(revmap(org.Dm.egUNIGENE), 5)
identical(Lkeys(org.Dm.egUNIGENE), Lkeys(revmap(org.Dm.egUNIGENE)))


###################################################
### code chunk number 4: tt-to-eg
###################################################
library(org.Dm.eg.db)
data(lrTest)
tt <- topTags(lrTest)


###################################################
### code chunk number 5: tt-to-eg1
###################################################
fbids <- rownames(tt$table)
egids <- unlist(mget(fbids, revmap(org.Dm.egFLYBASE), ifnotfound=NA))
egids


###################################################
### code chunk number 6: tt-to-eg2
###################################################
fbids <- rownames(tt$table)
map <- org.Dm.egFLYBASE
fbids <- intersect(mappedRkeys(map), fbids)
egids <- as.character(revmap(map)[fbids])
egids


###################################################
### code chunk number 7: <tt-annotate
###################################################
eg2fb <- toTable(org.Dm.egFLYBASE[egids])
eg2sym <- toTable(org.Dm.egSYMBOL[egids])
(anno0 <- merge(eg2fb, eg2sym))
(anno0 <- anno0[match(rownames(tt$table), anno0$flybase_id), ])
anno <- cbind(tt$table, anno0[ , c("gene_id", "symbol")])


