###

mapAlignedReadsToGenes <- function(aln)
{
    plus_reads <- normalizeAlignedReadChromosome(extractAlignedReadRanges(aln, "+"))
    minus_reads <- normalizeAlignedReadChromosome(extractAlignedReadRanges(aln, "-"))
    plus_genes <- normalizeGeneChromosome(extractYeastGenesAsRangesList("+"))
    minus_genes <- normalizeGeneChromosome(extractYeastGenesAsRangesList("-"))
    map <- vector(mode="list", length=length(aln))
    for (chrom in names(plus_reads)) {
        ## Map reads on the + strand with genes on the + strand.
        links <- as.matrix(findOverlaps(plus_reads[[chrom]], plus_genes[[chrom]]))
        read_ids <- names(plus_reads[[chrom]])[links[ , 1]]
        gene_ids <- names(plus_genes[[chrom]])[links[ , 2]]
        map2 <- split(gene_ids, read_ids)
        map[as.integer(names(map2))] <- map2
        ## Map reads on the - strand with genes on the - strand.
        links <- as.matrix(findOverlaps(minus_reads[[chrom]], minus_genes[[chrom]]))
        read_ids <- names(minus_reads[[chrom]])[links[ , 1]]
        gene_ids <- names(minus_genes[[chrom]])[links[ , 2]]
        map2 <- split(gene_ids, read_ids)
        map[as.integer(names(map2))] <- map2
    }
    map
}

