###

extractAlignedReadRanges <- function(aln, strand=NA)
{
    aln_ranges <- IRanges(start=position(aln), width=width(aln))
    names(aln_ranges) <- seq_len(length(aln))  # generate fake read id
    if (is.na(strand))
        idx <- TRUE
    else
        idx <- strand(aln) == strand
    split(aln_ranges[idx], chromosome(aln)[idx])
}

### Will work on the result of the previous function.
normalizeAlignedReadChromosome <- function(x)
{
    chrom <- sub("^chr0", "chr", substr(names(x), 1, 5))
    names(x) <- chrom
    x
}

