\name{ALLfilt_bcrneg}
\alias{ALLfilt_bcrneg}
\alias{ALLfilt}
\docType{data}

\title{Preprocessed Acute Lymphoblastic Leukemia Data}

\description{
  Preprocessed Acute Lymphoblastic Leukemia samples
  containing the B-cell tumors found to carry the BCR/ABL mutation and
  those B-cell tumors with no observed cytogenetic abnormalities (NEG).
}

\details{
  The \code{Allfilt_bcrneg} data is a subset of the Acute
  Lymphoblastic Leukemia samples (\code{\link[ALL]{ALL}}) in the ALL
  package.  The original \code{ALL} samples consist of microarrays from 128
  individuals with B-Cell and T-cell type acute lymphoblastic leukemia
  (ALL).  The \code{Allfilt_bcrneg} data is produced first by extracting the
  \code{ALL} samples with B-cell type and certain molecular biology of the
  cancer. Subsequently, non-specific filtering is performed on
  \code{ALLfilt_bcrneg} to remove non-informative probe sets. These
  non-informative probe sets includes probes that exhibit low expression
  variation across samples and have no GO IDs in the BP ontology and
  Entrez Gene IDs.  
}

\usage{
data(ALLfilt_bcrneg)
}

\examples{
data(ALLfilt_bcrneg)

## code chuck for getting Allfilt_bcrneg
\dontrun{
library(ALL)
data(ALL)
bcell <- grep("^B", as.character(ALL$BT))
types <- c("NEG", "BCR/ABL") 
moltyp <- which(as.character(ALL$mol.biol) %in% types)
# subsetting
ALL_bcrneg <- ALL[, intersect(bcell, moltyp)]
ALL_bcrneg$BT <- factor(ALL_bcrneg$BT)
ALL_bcrneg$mol.biol <- factor(ALL_bcrneg$mol.biol)
# nonspecific filter
library(genefilter)  
filt_bcrneg <- nsFilter(ALL_bcrneg, 
                    require.entrez=TRUE,
                    require.GOBP=TRUE, 
                    remove.dupEntrez=TRUE,
                    feature.exclude="^AFFX",
                    var.cutoff=0.5)
ALLfilt_bcrneg <- filt_bcrneg$eset
}

}

\author{
  Chao-Jen Wong \email{cwon2@fhcrc.org}
}

\seealso{
  \code{\link[ALL]{ALL}}
}

\references{
  
  Florian Hahne, Wolfgang Huber, Robert Gentleman, and Seth Falcon,
  \emph{Bioconductor Case Studies}, Chapter 1 and 2, Springer, 2008.
  }


