#!/bin/bash

# Location of BWA index
BWA_PREFIX=/home/public/bwa/hg18/hg18
# Location of UCSC genome for hg18 indexed fasta
UCSC_FAI=/home/public/sequences/ucsc/hg18/genome.fa.fai

# curl -L -O http://sourceforge.net/projects/maq/files/maq-data/20080929/calib-36.dat.gz/download
# mv download calib-36.dat.gz
# gunzip calib-36.dat

maq simulate -d 200 -s 20 -N 100000 \
  -1 35 -2 35 -R 0 \
  read1.fastq read2.fastq \
  sample.sequence.fa \
  calib-36.dat 

bwa aln -t 4 ${BWA_PREFIX} \
  read1.fastq > read1.sai

bwa aln -t 4 ${BWA_PREFIX} \
  read2.fastq > read2.sai

bwa sampe ${BWA_PREFIX} \
  read1.sai read2.sai \
  read1.fastq read2.fastq > reads.sam

samtools import ${UCSC_FAI} reads.sam reads.bam

samtools sort reads.bam reads.sorted

samtools index reads.sorted.bam
