#!/bin/bash

set -e  # Exit immediately if a simple command exits with a non-zero status
set -u  # Treat unset variables as an error
        # when performing parameter expansion.

#set -x # Print commands and their arguments as they are executed.

for file in `ls *-clean.gff`; do
    echo -n "Checking file $file... "
    tail1=`tail -n 1 $file`
    if [ "$tail1" == "##FASTA" ]; then
        echo "OK"
    else
        echo "ERROR: Wrong tail: $tail1"
    fi
done

