# NOT vectorized!
getAnnGenes <- function(chr)
{
    if (!is.character(chr) || length(chr) != 1 || is.na(chr))
        stop("'chr' must be a single string (not NA)")
    if (!(chr %in% names(GENE_TBLNAMES))) {
        if (substr(chr, 1, 3) == "chr")
            chr <- substr(chr, 4, nchar(chr))
    }
    tblname <- GENE_TBLNAMES[chr]
    if (is.na(tblname))
        stop("no gene annotations for this sequence")
    getdata(tblname)
}

# NOT vectorized!
getAnnExonParents <- function(chr)
{
    if (!is.character(chr) || length(chr) != 1 || is.na(chr))
        stop("'chr' must be a single string (not NA)")
    if (!(chr %in% names(EXONPARENTFEATURES_TBLNAMES))) {
        if (substr(chr, 1, 3) == "chr")
            chr <- substr(chr, 4, nchar(chr))
    }
    tblname <- EXONPARENTFEATURES_TBLNAMES[chr]
    if (is.na(tblname))
        stop("no exon-parent annotations for this sequence")
    getdata(tblname)
}

# NOT vectorized!
getAnnExons <- function(chr)
{
    if (!is.character(chr) || length(chr) != 1 || is.na(chr))
        stop("'chr' must be a single string (not NA)")
    if (!(chr %in% names(EXON_TBLNAMES))) {
        if (substr(chr, 1, 3) == "chr")
            chr <- substr(chr, 4, nchar(chr))
    }
    tblname <- EXON_TBLNAMES[chr]
    if (is.na(tblname))
        stop("no exon annotations for this sequence")
    getdata(tblname)
}

# Returns NA if 'name' is not a known gene ID, name or alias.
# Vectorized.
geneName2ID <- function(name)
{
    if (!is.character(name))
        stop("'name' not a character vector")
    GENE_ID2NAMES <- getdata("GENE_ID2NAMES")
    getGeneID <- function(nm)
    {
        for (geneID in names(GENE_ID2NAMES)) {
            if (geneID == nm || (nm %in% GENE_ID2NAMES[[geneID]]))
                return(geneID)
        }
        NA
    }
    sapply(name, getGeneID)
}

