# ============================================================================
# Serialized objects

# seq "U" omitted, see '?CHR_SHORTNAMES'
CHR_SHORTNAMES <- c("2L", "2R", "3L", "3R", "4", "X", "M")

# The names of the tables should be valid symbol names i.e. they should
# start with a letter and contain no ' ', '-' etc... ('.' and '_' are OK).
GENE_TBLNAMES <- paste("genes", CHR_SHORTNAMES, sep="")
EXONPARENTFEATURES_TBLNAMES <- paste("exonParentFeatures", CHR_SHORTNAMES, sep="")
EXON_TBLNAMES <- paste("exons", CHR_SHORTNAMES, sep="")
names(GENE_TBLNAMES) <- CHR_SHORTNAMES
names(EXONPARENTFEATURES_TBLNAMES) <- CHR_SHORTNAMES
names(EXON_TBLNAMES) <- CHR_SHORTNAMES

.SERIALIZED_OBJNAMES <- c(
    GENE_TBLNAMES,
    EXONPARENTFEATURES_TBLNAMES,
    EXON_TBLNAMES,
    "EXON2GENE",
    "GENE_ID2NAMES"
)


# ============================================================================
# Objects created "on-the-fly" (not serialized)

# WARNING: Improper calls to 'getdata' by the 'createObject' function can lead
# to infinite recursive loops!
createObject <- function(objname)
{
    # add some here...
    stop("don't know how to create object '", objname, "'")
}


# ============================================================================
# The 'getdata' function

datacache <- new.env(hash=TRUE, parent=emptyenv())

getdata <- function(objname)
{
    if (!exists(objname, envir=datacache)) {
        if (objname %in% .SERIALIZED_OBJNAMES) {
            data(list=objname, package="ann.Dmelanogaster.FlyBase.r51", envir=datacache)
        } else {
            assign(objname, createObject(objname), envir=datacache)
        }
    }
    get(objname, envir=datacache)
}

