#include "DNAhelperseth.h"

/*------------------------------------------*/
/* R interface                              */
/* reverse all elements of the input string */
/*------------------------------------------*/
SEXP MP_revstring(SEXP x)
{
  SEXP r;
  char *rev;
  int i, j, k, c, n;

  if( !isString(x) )
    error("argument must be a string");

  n = length(x);

  PROTECT(r = allocVector(STRSXP, n) );
  for(k=0; k<n; k++)
    SET_STRING_ELT(r, k, duplicate(STRING_ELT(x, k)));

  for(k=0; k<n; k++ ) {
    rev = CHAR(STRING_ELT(r, k));
    for(i = 0, j=strlen(rev)-1; i<j; i++, j--) {
	c = rev[i];
        rev[i] = rev[j];
        rev[j] = c;
    }
  }
  UNPROTECT(1);
  return(r);
} 
