
rf2 = function (exprObj, classifLab, trainInd, xtest, ytest, addclass = 0, 
    ntree = 500, mtry, classwt, cutoff, sampsize, nodesize, importance = FALSE, 
    proximity = FALSE, oob.prox = TRUE, outscale = FALSE, norm.votes = TRUE, 
    do.trace = FALSE, keep.forest = is.null(xtest), corr.bias = FALSE, 
    metric = "euclidean", ...) 
{
    trainDat <- t(exprObj@exprs[, trainInd])
    cl <- exprObj[[classifLab]][trainInd]
    if (missing(xtest)) {
        xtest <- NULL
    }
    if (missing(ytest)) {
        ytest <- NULL
    }
    if (missing(mtry)) {
        mtry <- sqrt(ncol(trainDat))
    }
    if (missing(classwt)) {
        classwt <- NULL
    }
    if (missing(nodesize)) {
        nodesize <- 1
    }
    if (missing(sampsize)) {
        sampsize <- table(cl)
    }
    testDat <- t(exprObj@exprs[, -trainInd])
    dis <- dist(testDat, method = metric)
    out <- randomForest::randomForest(trainDat, y = cl, xtest = xtest, 
        ytest = ytest, addclass = addclass, ntree = ntree, mtry = mtry, 
        classwt = classwt, cutoff = cutoff, sampsize = sampsize, 
        nodesize = nodesize, importance = importance, proximity = proximity, 
        oob.prox = oob.prox, outscale = outscale, norm.votes = norm.votes, 
        do.trace = do.trace, keep.forest = keep.forest, corr.bias = corr.bias, 
        ...)
# preds <- predict(out, testDat)
    new("classifOutput", method = "randomForest", 
        trainInds = trainInd, allClass = as.character(exprObj[[classifLab]]), 
        RObject = out, call = match.call(), distMat = dis)
}


