# -------------------------------------------------------------------------
# Image filters based on ImageMagick
# Bundled with src/flt_magick.{h,cpp}
 
# Copyright (c) 2005 Oleg Sklyar

# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License 
# as published by the Free Software Foundation; either version 2.1
# of the License, or (at your option) any later version.          

# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

# See the GNU Lesser General Public License for more details.
# LGPL license wording: http://www.gnu.org/licenses/lgpl.html

# -------------------------------------------------------------------------
# FOR INTERNAL USE BY THE DEVELOPERS ONLY (segmentation fault risk!)
.blur <- function(x, radius = 1, sigma = 0.5, modify = TRUE) {
    if (!assert(x))
        stop("Wrong class of argument x, Image expected")
    param = as.double(c(radius, sigma))
    filter = as.integer(2)
    if (!modify) {
        x = copy(x)
        return(.CallEBImage("stdFilter2D", x, filter, param))
    }
    else # original data modified
        invisible(.CallEBImage("stdFilter2D", x, filter, param))
}
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
blur <- function(x, radius = 1, sigma = 0.5) {
    .blur(x, radius, sigma, modify = FALSE)
}
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# FOR INTERNAL USE BY THE DEVELOPERS ONLY (segmentation fault risk!)
.contrast <- function(x, sharpen, modify = TRUE) {
    if (!assert(x))
        stop("Wrong class of argument x, Image expected")
    if (missing(sharpen))
        stop("argument 'sharpen' is essential")
    param = as.double(sharpen)
    filter = as.integer(3)
    if (!modify) {
        x = copy(x)
        return(.CallEBImage("stdFilter2D", x, filter, param))
    }
    else # original data modified
        invisible(.CallEBImage("stdFilter2D", x, filter, param))
}
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
contrast <- function(x, sharpen) {
    .contrast(x, sharpen, modify = FALSE)
}
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# FOR INTERNAL USE BY THE DEVELOPERS ONLY (segmentation fault risk!)
.despeckle <- function(x, modify = TRUE) {
    if (!assert(x))
        stop("Wrong class of argument x, Image expected")
    filter = as.integer(4)
    if (!modify) {
        x = copy(x)
        return(.CallEBImage("stdFilter2D", x, filter, NULL))
    }
    else # original data modified
        invisible(.CallEBImage("stdFilter2D", x, filter, NULL))
}
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
despeckle <- function(x) {
    .despeckle(x, modify = FALSE)
}
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# FOR INTERNAL USE BY THE DEVELOPERS ONLY (segmentation fault risk!)
.edge <- function(x, radius = 1, modify = TRUE) {
    if (!assert(x))
        stop("Wrong class of argument x, Image expected")
    param = as.double(radius)
    filter = as.integer(5)
    if (!modify) {
        x = copy(x)
        return(.CallEBImage("stdFilter2D", x, filter, param))
    }
    else # original data modified
        invisible(.CallEBImage("stdFilter2D", x, filter, param))
}
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
edge <- function(x, radius = 1) {
    .edge(x, radius)
}
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# FOR INTERNAL USE BY THE DEVELOPERS ONLY (segmentation fault risk!)
.enhance <- function(x, modify = TRUE) {
    if (!assert(x))
        stop("Wrong class of argument x, Image expected")
    filter = as.integer(6)
    if (!modify) {
        x = copy(x)
        return(.CallEBImage("stdFilter2D", x, filter, NULL))
    }
    else # original data modified
        invisible(.CallEBImage("stdFilter2D", x, filter, NULL))
}
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
enhance <- function(x) {
    .enhance(x, modify = FALSE)
}
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# FOR INTERNAL USE BY THE DEVELOPERS ONLY (segmentation fault risk!)
.equalize <- function(x, modify = TRUE) {
    if (!assert(x))
        stop("Wrong class of argument x, Image expected")
    filter = as.integer(7)
    if (!modify) {
        x = copy(x)
        return(.CallEBImage("stdFilter2D", x, filter, NULL))
    }
    else # original data modified
        invisible(.CallEBImage("stdFilter2D", x, filter, NULL))
}
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
equalize <- function(x) {
    .equalize(x, modify = FALSE)
}
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#ffill <- function(x, col, row, color, modify = FALSE) {
#    .notImageError(x)
#    if (missing(col) || missing(height))
#        stop("arguments 'col', 'row' and 'color' are essential")
#    if (x@rgb) {
#        red = getRed(as.integer(color))
#        green = getGreen(as.integer(color))
#        blue = getBlue(as.integer(color))
#        param = as.double(c(col, row, red, green, blue))
#    }
#    else
#        param = as.double(c(col, color))
#    filter = as.integer(8)
#    if (!modify) {
#        x = copy(x)
#        return(.CallEBImage("stdFilter2D", x, filter, param))
#    }
#    else # original data modified
#        invisible(.CallEBImage("stdFilter2D", x, filter, param))
#}
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#ffillEdge <- function(x, col, row, color, modify = FALSE) {
#    .notImageError(x)
#    if (missing(col) || missing(height))
#        stop("arguments 'col', 'row' and 'color' are essential")
#    if (x@rgb) {
#        red = getRed(as.integer(color))
#        green = getGreen(as.integer(color))
#        blue = getBlue(as.integer(color))
#        param = as.double(c(col, row, red, green, blue))
#    }
#    else
#        param = as.double(c(col, color))
#    filter = as.integer(9)
#    if (!modify) {
#        x = copy(x)
#        return(.CallEBImage("stdFilter2D", x, filter, param))
#    }
#    else # original data modified
#        invisible(.CallEBImage("stdFilter2D", x, filter, param))
#}
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# FOR INTERNAL USE BY THE DEVELOPERS ONLY (segmentation fault risk!)
.colorGamma <- function(x, level, modify = TRUE) {
    if (!assert(x))
        stop("Wrong class of argument x, Image expected")
    if (missing(level))
        stop("argument 'level' is essential")
    param = as.double(level)
    filter = as.integer(10)
    if (!modify) {
        x = copy(x)
        return(.CallEBImage("stdFilter2D", x, filter, param))
    }
    else # original data modified
        invisible(.CallEBImage("stdFilter2D", x, filter, param))
}
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
colorGamma <- function(x, level) {
    .colorGamma(x, level, modify = FALSE)
}
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# FOR INTERNAL USE BY THE DEVELOPERS ONLY (segmentation fault risk!)
.gaussFilter <- function(x, width = 1, sigma = 0.5, modify = TRUE) {
    if (!assert(x))
        stop("Wrong class of argument x, Image expected")
    param = as.double(c(width, sigma))
    filter = as.integer(11)
    if (!modify) {
        x = copy(x)
        return(.CallEBImage("stdFilter2D", x, filter, param))
    }
    else
        invisible(.CallEBImage("stdFilter2D", x, filter, param))
}
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
gaussFilter <- function(x, width = 1, sigma = 0.5) {
    .gaussFilter(x, width, sigma, modify = FALSE)
}
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# FOR INTERNAL USE BY THE DEVELOPERS ONLY (segmentation fault risk!)
.medianFilter <- function(x, radius = 2, modify = TRUE) {
    if (!assert(x))
        stop("Wrong class of argument x, Image expected")
    param = as.double(radius)
    filter = as.integer(12)
    if (!modify) {
        x = copy(x)
        return(.CallEBImage("stdFilter2D", x, filter, param))
    }
    else # original data modified
        invisible(.CallEBImage("stdFilter2D", x, filter, param))
}
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
medianFilter <- function(x, radius = 2) {
    .medianFilter(x, radius, modify = FALSE)
}
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# FOR INTERNAL USE BY THE DEVELOPERS ONLY (segmentation fault risk!)
# FIXME: do not know why I always get black image
.mod <- function(x, brightness = 1, saturation = 1, hue = 1, modify = TRUE) {
    if (!assert(x))
        stop("Wrong class of argument x, Image expected")
    param = as.double(c(brightness, saturation, hue))
    filter = as.integer(13)
    if (!modify) {
        x = copy(x)
        return(.CallEBImage("stdFilter2D", x, filter, param))
    }
    else # original data modified
        invisible(.CallEBImage("stdFilter2D", x, filter, param))
}
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
mod <- function(x, brightness = 1, saturation = 1, hue = 1) {
    .mod(x, brightness, saturation, hue, modify = FALSE)
}
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# FOR INTERNAL USE BY THE DEVELOPERS ONLY (segmentation fault risk!)
.reduceNoise <- function(x, order = NULL, modify = TRUE) {
    if (!assert(x))
        stop("Wrong class of argument x, Image expected")
    if (is.null(order))
        order = -1
    param = as.double(order)
    filter = as.integer(14)
    if (!modify) {
        x = copy(x)
        return(.CallEBImage("stdFilter2D", x, filter, param))
    }
    else # original data modified
        invisible(.CallEBImage("stdFilter2D", x, filter, param))
}
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
reduceNoise <- function(x, order = NULL) {
    .reduceNoise(x, order, modify = FALSE)
}
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
rotate <- function(x, degrees = 90) {
    if (!assert(x))
        stop("Wrong class of argument x, Image expected")
    param = as.double(degrees)
    filter = as.integer(15)
    return(.CallEBImage("stdFilter2DRedim", x, filter, param))
}
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
sample.image <- function(x, dx, dy) {
    if (!assert(x))
        stop("Wrong class of argument x, Image expected")
    if (missing(dx) || missing(dy))
        stop("arguments 'dx' and 'dy' are essential")
    param = as.double(c(dx, dy))
    filter = as.integer(16)
    return(.CallEBImage("stdFilter2DRedim", x, filter, param))
}
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#scale.image <- function(x, dx, dy) {
#    if (!assert(x))
#        stop("Wrong class of argument x, Image expected")
#    if (missing(dx) || missing(dy))
#        stop("arguments 'dx' and 'dy' are essential")
#    param = as.double(c(dx, dy))
#    filter = as.integer(17)
#    return(.CallEBImage("stdFilter2DRedim", x, filter, param))
#}
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
zoom.image <- function(x, dx, dy) {
    if (!assert(x))
        stop("Wrong class of argument x, Image expected")
    if (missing(dx) || missing(dy))
        stop("arguments 'dx' and 'dy' are essential")
    param = as.double(c(dx, dy))
    filter = as.integer(25)
    return(.CallEBImage("stdFilter2DRedim", x, filter, param))
}
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# FOR INTERNAL USE BY THE DEVELOPERS ONLY (segmentation fault risk!)
.segment <- function(x, cluster = 1, smooth = 1.5, modify = TRUE) {
    if (!assert(x))
        stop("Wrong class of argument x, Image expected")
    param = as.double(c(cluster, smooth))
    filter = as.integer(18)
    if (!modify) {
        x = copy(x)
        return(.CallEBImage("stdFilter2D", x, filter, param))
    }
    else # original data modified
        invisible(.CallEBImage("stdFilter2D", x, filter, param))
}
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
segment <- function(x, cluster = 1, smooth = 1.5) {
    .segment(x, cluster, smooth, modify = FALSE)
}
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# FOR INTERNAL USE BY THE DEVELOPERS ONLY (segmentation fault risk!)
# FIXME: wrong number of parameters reported
.shade <- function(x, azimuth = 30, elevation = 30, shading = FALSE, modify = TRUE) {
    if (!assert(x))
        stop("Wrong class of argument x, Image expected")
    param = as.double(c(azimuth, elevation))
    filter = as.integer(19)
    if (!modify) {
        x = copy(x)
        return(.CallEBImage("stdFilter2D", x, filter, param))
    }
    else # original data modified
        invisible(.CallEBImage("stdFilter2D", x, filter, param))
}
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
shade <- function(x, azimuth = 30, elevation = 30, shading = FALSE) {
    .shade(x, azimuth, elevation, shading, modify = FALSE)
}
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# FOR INTERNAL USE BY THE DEVELOPERS ONLY (segmentation fault risk!)
.sharpen <- function(x, radius = 1, sigma = 0.5, modify = TRUE) {
    if (!assert(x))
        stop("Wrong class of argument x, Image expected")
    param = as.double(c(radius, sigma))
    filter = as.integer(20)
    if (!modify) {
        x = copy(x)
        return(.CallEBImage("stdFilter2D", x, filter, param))
    }
    else # original data modified
        invisible(.CallEBImage("stdFilter2D", x, filter, param))
}
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
sharpen <- function(x, radius = 1, sigma = 0.5) {
    .sharpen(x, radius, sigma, modify = FALSE)
}
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# FOR INTERNAL USE BY THE DEVELOPERS ONLY (segmentation fault risk!)
.solarize <- function(x, factor = 50, modify = TRUE) {
    if (!assert(x))
        stop("Wrong class of argument x, Image expected")
    param = as.double(factor)
    filter = as.integer(21)
    if (!modify) {
        x = copy(x)
        return(.CallEBImage("stdFilter2D", x, filter, param))
    }
    else # original data modified
        invisible(.CallEBImage("stdFilter2D", x, filter, param))
}
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
solarize <- function(x, factor = 50) {
    .solarize(x, factor, modify = FALSE)
}
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# FOR INTERNAL USE BY THE DEVELOPERS ONLY (segmentation fault risk!)
.spread <- function(x, amount = 3, modify = TRUE) {
    if (!assert(x))
        stop("Wrong class of argument x, Image expected")
    param = as.double(amount)
    filter = as.integer(22)
    if (!modify) {
        x = copy(x)
        return(.CallEBImage("stdFilter2D", x, filter, param))
    }
    else # original data modified
        invisible(.CallEBImage("stdFilter2D", x, filter, param))
}
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
spread <- function(x, amount = 3) {
    .spread(x, amount, modify = FALSE)
}
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# FOR INTERNAL USE BY THE DEVELOPERS ONLY (segmentation fault risk!)
.unsharpMask <- function(x, radius = 2, sigma = 0.5, amount = 5, threshold = 2, modify = TRUE) {
    if (!assert(x))
        stop("Wrong class of argument x, Image expected")
    param = as.double(c(radius, sigma, amount, threshold))
    filter = as.integer(23)
    if (!modify) {
        x = copy(x)
        return(.CallEBImage("stdFilter2D", x, filter, param))
    }
    else # original data modified
        invisible(.CallEBImage("stdFilter2D", x, filter, param))
}
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
unsharpMask <- function(x, radius = 2, sigma = 0.5, amount = 5, threshold = 2) {
    .unsharpMask(x, radius, sigma, amount, threshold, modify = FALSE)
}
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# FOR INTERNAL USE BY THE DEVELOPERS ONLY (segmentation fault risk!)
.noise <- function(x, type = "gaussian", modify = TRUE) {
    if (!assert(x))
        stop("Wrong class of argument x, Image expected")
    param = as.double(
        switch(type,
            "uniform" = 1,
            "gaussian" = 2,
            "multi" = 3,
            "impulse" = 4,
            "laplace" = 5,
            "poisson" = 6,
            2
        )
    )
    filter = as.integer(24)
    if (!modify) {
        x = copy(x)
        return(.CallEBImage("stdFilter2D", x, filter, param))
    }
    else # original data modified
        invisible(.CallEBImage("stdFilter2D", x, filter, param))
}
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# possible types: uniform, gaussian, multi(plicativeGaussian), impulse, laplace(ian), poisson
noise <- function(x, type = "gaussian") {
    .noise(x, type, modify = FALSE)
}
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# FOR INTERNAL USE BY THE DEVELOPERS ONLY (segmentation fault risk!)
.trim <- function(x, bg = 0, modify = TRUE) {
    if (!assert(x))
        stop("Wrong class of argument x, Image expected")
    param = as.double(bg)
    filter = as.integer(26)
    if (!modify) {
        x = copy(x)
        return(.CallEBImage("stdFilter2D", x, filter, param))
    }
    else # original data modified
        invisible(.CallEBImage("stdFilter2D", x, filter, param))
}
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
trim <- function(x, bg = 0) {
    .trim(x, bg, modify = FALSE)
}
