## ----style, echo = FALSE, results = 'asis'--------------------------------------------------------
options(width=100)
knitr::opts_chunk$set(
    eval=as.logical(Sys.getenv("KNITR_EVAL", "TRUE")),
    cache=as.logical(Sys.getenv("KNITR_CACHE", "TRUE")))

## ----setup, echo=FALSE----------------------------------------------------------------------------
suppressPackageStartupMessages({
    library(Biostrings)
    library(GenomicRanges)
})

## ----require--------------------------------------------------------------------------------------
library(GenomicRanges)

## ----help, eval=FALSE-----------------------------------------------------------------------------
#  help(package="GenomicRanges")
#  vignette(package="GenomicRanges")
#  vignette(package="GenomicRanges", "GenomicRangesHOWTOs")
#  ?GRanges

## -------------------------------------------------------------------------------------------------
library(Biostrings)
data(phiX174Phage)
phiX174Phage
letterFrequency(phiX174Phage, c("A", "C", "G", "T"))
letterFrequency(phiX174Phage, "GC", as.prob=TRUE)

