## ----style, echo = FALSE, results = 'asis'--------------------------------------------------------
options(width=100)
knitr::opts_chunk$set(
    eval=as.logical(Sys.getenv("KNITR_EVAL", "TRUE")),
    cache=as.logical(Sys.getenv("KNITR_CACHE", "TRUE")))

## ----echo=FALSE-----------------------------------------------------------------------------------
suppressPackageStartupMessages({
    library(RColorBrewer)
    library(ggplot2)
})

## ----colorbrewer----------------------------------------------------------------------------------
library(RColorBrewer)
display.brewer.all()

## ----color-choice---------------------------------------------------------------------------------
palette <- brewer.pal(4, "Dark2")

## ----mtcars---------------------------------------------------------------------------------------
data(mtcars)     # load the data set
head(mtcars)

## ----plot-mtcars----------------------------------------------------------------------------------
plot(mpg ~ hp, mtcars)

## ----plot-mtcars-2--------------------------------------------------------------------------------
plot(mpg ~ hp, mtcars, pch=20, cex=2, col=palette[1])

## ----plot-mtcars-regression-----------------------------------------------------------------------
plot(mpg ~ hp, mtcars)
fit <- lm(mpg ~ hp, mtcars)
abline(fit, col=palette[1], lwd=3)

## ----ggplot2--------------------------------------------------------------------------------------
library(ggplot2)

## ----ggplot, eval=FALSE---------------------------------------------------------------------------
#  ggplot(mtcars, aes(x=hp, y=mpg))

## ----ggplot-point---------------------------------------------------------------------------------
ggplot(mtcars, aes(x=hp, y=mpg)) + geom_point()

## ----ggplot-lm, warning=FALSE---------------------------------------------------------------------
ggplot(mtcars, aes(x=hp, y=mpg)) + geom_point() +
    geom_smooth(method=lm, col=palette[1])

## ----ggplot-smooth, warning=FALSE-----------------------------------------------------------------
ggplot(mtcars, aes(x=hp, y=mpg)) + geom_point() +
    geom_smooth(method=lm, col=palette[1]) +
    geom_smooth(col=palette[2])

## ----file.choose, eval=FALSE----------------------------------------------------------------------
#  path <- file.choose()

## ----system.file, echo=FALSE----------------------------------------------------------------------
path <- system.file(package="BiocIntroRPCI", "extdata", "BRFSS-subset.csv")

## ----brfss-input----------------------------------------------------------------------------------
brfss <- read.csv(path)

## ----brfss-density, warning=FALSE-----------------------------------------------------------------
ggplot(brfss, aes(x=Weight)) + geom_density()

## ----brfss-density-by-year, warning=FALSE---------------------------------------------------------
ggplot(brfss, aes(x=Weight, fill=factor(Year))) +
    geom_density(alpha=0.5)

## ----brfss-facet, warning=FALSE-------------------------------------------------------------------
ggplot(brfss, aes(x=Weight, fill=factor(Year))) +
    geom_density() +
    facet_grid(Sex ~ .)

