## ----setup, echo=FALSE---------------------------------------------------
library(LearnBioconductor)
stopifnot(BiocInstaller::biocVersion() == "3.0")

## ----style, echo = FALSE, results = 'asis'-------------------------------
BiocStyle::markdown()

## ----workflow-code-chunks, eval=FALSE------------------------------------
#  library(airway)
#  library(DESeq2)
#  
#  data(airway)
#  
#  dds <- DESeqDataSet(airway, design = ~ cell + dex)
#  dds$dex <- relevel(dds$dex, "untrt")
#  dds <- DESeq(dds)
#  res <- results(dds)

