## ----setup, echo=FALSE---------------------------------------------------
library(LearnBioconductor)
stopifnot(BiocInstaller::biocVersion() == "3.0")

## ----style, echo = FALSE, results = 'asis'-------------------------------
BiocStyle::markdown()

## ----fun-----------------------------------------------------------------
fun <- function(n) {
    x <- rnorm(n)
    y <- x + rnorm(n, sd=.5)
    lm(y ~ x)
}

## ----iteration, eval=FALSE-----------------------------------------------
#  ## 'side effects'
#  for (i in 1:10)
#      message(i)
#  
#  ## result for subsequent computation
#  sapply(1:10, function(i) {
#      sum(rnorm(1000))
#  })

## ----conditional, eval=FALSE---------------------------------------------
#  sapply(1:10, function(i)) {
#      if (sum(rnorm(1000)) > 0) {
#          "hi!"
#      } else {
#          "low!"
#      }
#  })

