\name{scriptPath}
\alias{scriptPath}
\alias{readScript}

\title{
  Determine the file path and read scripts in this package.
}
\description{

  These helper functions locate and read scripts associated with the
  AdvancedR package.
  
}
\usage{
scriptPath(scriptName)
readScript(scriptName)
}

\arguments{

  \item{scriptName}{The name of the script, e.g.,
    \dQuote{fapply.R}. \code{scriptName} may be missing for
    \code{scriptPath}.}

}

\value{

  \code{scriptPath} returns the path to \code{scriptName} as
  \code{character(1)}. If \code{scriptName} is missing, the return value
  is the directory in which the scripts are installed.

  \code{readScript} returns the content of the script as
  \code{character()}, one line per script, arranging not to quote
  strings.

}
\author{
  Martin Morgan \url{mtmorgan@fhcrc.org}
}

\examples{
list.files(scriptPath()) # available scripts
scriptPath('fapply.R')
readScript('fapply.R')
}

\keyword{manip}
