## Initial Classes
setClass("Sample",
         representation("VIRTUAL",
                        description = "character"))

setClass("OneSample", contains = "Sample",
         representation(one = "numeric"))
setClass("TwoSample", contains = "Sample",
         representation(one = "numeric",
                        two = "numeric"))


## Exercise 1
setClass("PairedSample", contains = "TwoSample",
    validity = function(object) {
        if (length(object@one) != length(object@two))
            "unequal sample lengths"
        else
            TRUE
    })


## Exercise 2
setGeneric("tTest", signature = "x",
    function(x, alternative = c("two.sided", "less", "greater"),
             mu = 0, conf.level = 0.95, ...)
        standardGeneric("tTest"))

setMethod("tTest", "OneSample",
    function(x, alternative = c("two.sided", "less", "greater"),
             mu = 0, conf.level = 0.95)
        t.test(x@one, alternative = match.arg(alternative),
               mu = mu, conf.level = conf.level))

setMethod("tTest", "TwoSample",
    function(x, alternative = c("two.sided", "less", "greater"),
             mu = 0, conf.level = 0.95, var.equal = FALSE)
        t.test(x@one, x@two, alternative = match.arg(alternative),
               mu = mu, conf.level = conf.level,
               var.equal = var.equal))

setMethod("tTest", "PairedSample",
    function(x, alternative = c("two.sided", "less", "greater"),
             mu = 0, conf.level = 0.95)
        t.test(x@one, x@two, alternative = match.arg(alternative),
               mu = mu, conf.level = conf.level, paired = TRUE))


## Exercise 3
setMethod("show", "OneSample",
    function(object)
    {
        cat(class(object), "of length", length(object@one), "\n")
        print(object@one)
    })

setMethod("show", "TwoSample",
    function(object)
    {
        cat(class(object), " with lengths ", length(object@one),
            " and ", length(object@two), "\n", sep = "")
        cat("one:\n")
        print(object@one)
        cat("two:\n")
        print(object@two)
    })

setMethod("show", "PairedSample",
    function(object)
    {
        cat(class(object), "of length", length(object@one), "\n")
        print(cbind(one = object@one, two = object@two))
    })
