###################################################
### chunk number 1: setup
###################################################
options(width = 62)


###################################################
### chunk number 2: makeUCSC eval=FALSE
###################################################
## library(GenomicFeatures)
## mm9KG <-
##   makeTranscriptDbFromUCSC(genome = "mm9",
##                            tablename = "knownGene")


###################################################
### chunk number 3: preload
###################################################
library(GenomicFeatures)
if(!exists("mm9KG",mode="TranscriptDb")) {
    mm9KG <-
      loadFeatures(system.file("extdata","mm9KG.sqlite",
                                package = "AdvancedR"))
}


###################################################
### chunk number 4: saveAndLoad eval=FALSE
###################################################
## saveFeatures(mm9KG, file="mm9KG.sqlite")
## mm9KG <-
##   loadFeatures(system.file("extdata", "mm9KG.sqlite",
##                            package = "AdvancedR"))


###################################################
### chunk number 5: transcripts
###################################################
head(transcripts(mm9KG), 3)


###################################################
### chunk number 6: transcriptsDetails eval=FALSE
###################################################
## options(verbose=TRUE)
## txs <- transcripts(mm9KG)


###################################################
### chunk number 7: driverUsageAndListTables
###################################################
library(RSQLite) #loads DBI too, (but we need both)
drv <- dbDriver("SQLite")
con <- dbConnect(drv, dbname=system.file("extdata", 
                 "mm9KG.sqlite", package="AdvancedR"))
dbListTables(con)
dbListFields(con,"transcript")


###################################################
### chunk number 8: dbGetQuery
###################################################
dbGetQuery(con, "SELECT * FROM transcript LIMIT 3")


###################################################
### chunk number 9: dbSendQuery
###################################################
res <- dbSendQuery(con, "SELECT * FROM transcript")
fetch(res, n= 3)
dbClearResult(res)


###################################################
### chunk number 10: exercise1
###################################################
sql <- "SELECT * FROM exon WHERE exon.exon_strand='-' 
        AND exon.exon_chrom='chr9'"
res <- dbGetQuery(con, sql)
head(res)

###################################################
### chunk number 11: dbDisconnect
###################################################
   dbDisconnect(con)


###################################################
### chunk number 12: makeNewDb
###################################################
drv <- dbDriver("SQLite")
con <- dbConnect(drv, dbname="myNewDb.sqlite")


###################################################
### chunk number 13: CreateNewTable
###################################################
dbGetQuery(con, "CREATE Table foo (id INTEGER, string TEXT)")


###################################################
### chunk number 14: exercise2
###################################################
drv <- dbDriver("SQLite")
dbcon <- dbConnect(drv, dbname="myExDb.sqlite")
dbGetQuery(dbcon, 
           paste("CREATE Table genePheno 
           (id INTEGER, string TEXT)"))


###################################################
### chunk number 15: LabelledPreparedQueries
###################################################
data <- data.frame(c(226089,66745),
                  c("C030046E11Rik","Trpd52l3"), 
                  stringsAsFactors=FALSE)
names(data) <- c("id","string")
sql <- "INSERT INTO foo VALUES ($id, $string)"
dbBeginTransaction(con)
dbGetPreparedQuery(con, sql, bind.data = data)
dbCommit(con)


###################################################
### chunk number 16: exercise3
###################################################
data <- data.frame(id=c(69773,20586,258822,18315),
                   string=c("Dead",
                            "Alive",
                            "Dead",
                            "Alive"),
                   stringsAsFactors=FALSE)
sql <- "INSERT INTO genePheno VALUES ($id,$string)"
dbBeginTransaction(dbcon)
dbGetPreparedQuery(dbcon, sql, bind.data = data)
dbCommit(dbcon)


###################################################
### chunk number 17: ATTACH
###################################################
db <- system.file("extdata", "mm9KG.sqlite", 
                  package="AdvancedR")
dbGetQuery(con, sprintf("ATTACH '%s' AS db",db))


###################################################
### chunk number 18: ATTACHJoin
###################################################
  sql <- "SELECT * FROM db.gene AS dbg, 
          foo AS f WHERE dbg.gene_id=f.id"
  res <- dbGetQuery(con, sql)
  res


###################################################
### chunk number 19: exercise4
###################################################
  #1st attach
  db <- system.file("extdata", "mm9KG.sqlite", 
                    package="AdvancedR")
  dbGetQuery(dbcon, sprintf("ATTACH '%s' AS db",db))
  #then select
  sql <- "SELECT * FROM db.gene AS dbg, 
          genePheno AS gp WHERE dbg.gene_id=gp.id"
  res <- dbGetQuery(dbcon, sql)
  head(res)

###################################################
### chunk number 20: exercise5
###################################################
  sql <- "SELECT * FROM db.gene AS dbg, 
          genePheno AS gp, transcript AS t 
          WHERE dbg.gene_id=gp.id
          AND dbg._tx_id=t._tx_id"
  res <- dbGetQuery(dbcon, sql)
  head(res)

###################################################
### chunk number 21: cleanup
###################################################
## unlink("myNewDb.sqlite")
## unlink("myExDb.sqlite")


