#include "path.h"

const char *
nid_path_expand(const char *s)
{
    SEXP v, fun, ans;
    const char *p;
    PROTECT(v = Rf_mkString(s));
    PROTECT(fun = Rf_lang2(Rf_install("path.expand"), v));
    /* We use the base environment here for evaluation.
       There is a non-documented, but accessible API to create
       an environment: R_NewHashedEnv
     */
    ans = eval(fun, R_BaseEnv);
    p = CHAR(STRING_ELT(ans, 0));
    UNPROTECT(2);
    return p;
}
