#include <Rinternals.h>

double _nid_avg(int *data, int len)
{
    int i;
    double ans = 0.0;
    for (i = 0; i < len; i++) {
        ans += data[i];
    }
    return ans / len;
}

SEXP nid_avg(SEXP data)
{
    double v = _nid_avg(INTEGER(data), Rf_length(data));
    return Rf_ScalarReal(v);
}

void nid_avg0(int *data, int *len, double *ans)
{
    int i;
    *ans = 0.0;
    for (i = 0; i < *len; i++) {
        *ans += data[i];
    }
    *ans /= *len;
}
