CREATE TABLE cds (
  _cds_id INTEGER PRIMARY KEY,
  cds_name TEXT NULL,
  cds_chrom TEXT NOT NULL,
  cds_strand TEXT NOT NULL,
  cds_start INTEGER NOT NULL,
  cds_end INTEGER NOT NULL,
  FOREIGN KEY (cds_chrom) REFERENCES chrominfo (chrom)
);
CREATE TABLE chrominfo (
  _chrom_id INTEGER PRIMARY KEY,
  chrom TEXT UNIQUE NOT NULL,
  length INTEGER NULL
);
CREATE TABLE exon (
  _exon_id INTEGER PRIMARY KEY,
  exon_name TEXT NULL,
  exon_chrom TEXT NOT NULL,
  exon_strand TEXT NOT NULL,
  exon_start INTEGER NOT NULL,
  exon_end INTEGER NOT NULL,
  FOREIGN KEY (exon_chrom) REFERENCES chrominfo (chrom)
);
CREATE TABLE gene (
  gene_id TEXT NOT NULL,
  _tx_id INTEGER NOT NULL,
  UNIQUE (gene_id, _tx_id),
  FOREIGN KEY (_tx_id) REFERENCES transcript
);
CREATE TABLE metadata 
( name TEXT,
	"value" TEXT 
);
CREATE TABLE splicing (
  _tx_id INTEGER NOT NULL,
  exon_rank INTEGER NOT NULL,
  _exon_id INTEGER NOT NULL,
  _cds_id INTEGER NULL,
  UNIQUE (_tx_id, exon_rank),
  FOREIGN KEY (_tx_id) REFERENCES transcript,
  FOREIGN KEY (_exon_id) REFERENCES exon,
  FOREIGN KEY (_cds_id) REFERENCES cds
);
CREATE TABLE transcript (
  _tx_id INTEGER PRIMARY KEY,
  tx_name TEXT NULL,
  tx_chrom TEXT NOT NULL,
  tx_strand TEXT NOT NULL,
  tx_start INTEGER NOT NULL,
  tx_end INTEGER NOT NULL,
  FOREIGN KEY (tx_chrom) REFERENCES chrominfo (chrom)
);
